package coins.backend.lir;

import coins.backend.*;
import coins.backend.util.*;

/** Represent FLOATCONST node. */
public class LirFconst extends LirNode {
  public final double value;

  public LirFconst(int id, int t, double v, ImList opt) {
    super(id, Op.FLOATCONST, t, opt);
    value = v;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.fconst(type, value, opt);
  }

  public int hashCode() {
    long v = Double.doubleToLongBits(value);
    return (int)(v ^ (v >> 32) ^ type);
  }

  public String toString() {
    return (Debug.showId ? "$"+id+":" : "")
      + "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public boolean equals(Object x) {
    return (x instanceof LirFconst && super.equals(x)
            && value == ((LirFconst)x).value);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}

