package coins.backend.opt;

import java.util.*;
import coins.backend.*;
import coins.backend.util.*;
import coins.backend.lir.*;
import coins.backend.cfg.*;
import coins.backend.sym.*;

/** Canonicalize JUMP instructions so that
 *   their false-target have the label of block afterward. **/
public class JumpCanon implements LocalTransform {

  private BackEnd root;

  public JumpCanon(BackEnd root) {
    this.root = root;
  }

  /** Canonicalize jumps */
  public void doIt(Function f) {
    FlowGraph g = f.flowGraph;

    for (BiLink p = g.basicBlkList.first(); !p.atEnd(); p = p.next()) {
      BasicBlk blk = (BasicBlk)p.elem();

      BasicBlk nextblk = null;
      if (!p.next().atEnd())
        nextblk = (BasicBlk)p.next().elem();
      BiLink lastp = blk.instrList().last();
      if (!lastp.atEnd()) {
        LirNode ins = (LirNode)lastp.elem();
        if (ins.opCode == Op.JUMPC) {
          Label[] targets = ins.getTargets();
          if (targets[1].basicBlk() == nextblk)
            ;
          else if (targets[0].basicBlk() == nextblk) {
            // Reverse condition and swap true/false labels.
            int testOp = flipCondition(ins.src(0).opCode);
            lastp.setElem(f.newLir
                          .operator(Op.JUMPC, Type.UNKNOWN,
                                    f.newLir.operator(testOp,
                                                      ins.src(0).type,
                                                      ins.src(0).src(0),
                                                      ins.src(0).src(1), null),
                                    ins.src(2), ins.src(1), null));
          }
          else {
            // insert new block and rewrite false-target
            BasicBlk newblk = f.flowGraph.insertNewBlkBefore(nextblk);
            LirNode jmp = (LirNode)newblk.instrList().last().elem();
            jmp.setSrc(0, ins.src(2));
            ins.setSrc(2, f.newLir.labelRef(newblk.label()));

            newblk.maintEdges();
            blk.maintEdges();
          }
        }
      }
    }
  }

  
  /** Flip test instruction **/
  private int flipCondition(int testOp) {
    switch (testOp) {
    case Op.TSTEQ: return Op.TSTNE;
    case Op.TSTNE: return Op.TSTEQ;
    case Op.TSTLTS: return Op.TSTGES;
    case Op.TSTLES: return Op.TSTGTS;
    case Op.TSTGTS: return Op.TSTLES;
    case Op.TSTGES: return Op.TSTLTS;
    case Op.TSTLTU: return Op.TSTGEU;
    case Op.TSTLEU: return Op.TSTGTU;
    case Op.TSTGTU: return Op.TSTLEU;
    case Op.TSTGEU: return Op.TSTLTU;
    default:
      throw new IllegalArgumentException("non-test op");
    }
  }
}
