package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.util.*;

/** Symbol table entry for automatic objects */
public class SymAuto extends Symbol {
  /** Offset of the FRAME object */
  public final int offset;

  /** Create automatic objects' symbol entry. Only SymTab calls. */
  SymAuto(SymTab table, String name, int id, int storage, int type, int boundary,
          int offset, ImList opt) {
    super(table, name, id, storage, type, boundary, opt);
    this.offset = offset;
  }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + Storage.toString(storage)
      + " " + Type.toString(type) + " "
      + boundary + " "
      + offset
      + preSpace(flagsToString())
      + (shadow != null ? " &shadow \"" + shadow.name + "\"" : "")
      + preSpace(opt.toStringWOParen())
      + ")";
  }
}
