package coins.backend.sym;

import java.io.*;
import coins.backend.*;
import coins.backend.util.*;

/** Symbol table entry for static objects */
public class SymStatic extends Symbol {
  /** Segment name */
  public final String segment;

  /** Indicates whether external or internal */
  public final String linkage;

  /** Body of the function. */
  Function body;

  /** Create static objects' symbol entry. Only SymTab calls. */
  SymStatic(SymTab table, String name, int id, int storage, int type, int boundary,
            String segment, String linkage, ImList opt) {
    super(table, name, id, storage, type, boundary, opt);
    this.segment = segment;
    this.linkage = linkage;
  }

  /** Return body */
  public Function body() { return body; }

  /** Set function body */
  public void setBody(Function func) { body = func; }

  /** Visualize */
  public String toString() {
    return "(\"" + name + "\" " + Storage.toString(storage)
      + " " + Type.toString(type)
      + " " + boundary + " " + segment + " " + linkage
      + preSpace(flagsToString()) + preSpace(opt.toStringWOParen()) + ")";
  }
}
