
import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.ana.*;
import coins.backend.opt.*;
import coins.backend.util.*;

/**
 * Back end of COINS compiler
 */
class BackEnd extends Object {
  public static void main(String[] args) throws IOException {
    if (args.length != 1) {
      System.err.println("java BackEnd lirfile");
      return;
    }
    PushbackReader stdin
      = new PushbackReader(new InputStreamReader(new FileInputStream(args[0])));
    PrintWriter stdout = new PrintWriter(System.out, true);
    Object sexp;

    try {
      while ((sexp = ImList.readSexp(stdin)) != null) {
        // System.err.println(sexp.toString());
        // Read LIR
        Module compileUnit = new Module(sexp, stdout);

        // Apply analyses
        compileUnit.apply(Dominators.analyzer);
        compileUnit.apply(DominanceFrontiers.analyzer);

        if (Debug.dumpModule)
          compileUnit.printIt(stdout,
               new LocalAnalyzer[]{Dominators.analyzer,
                                   DominanceFrontiers.analyzer});

        // Apply optimization
        compileUnit.apply(new IntroVirReg(stdout));
        if (Debug.dumpModule) {
          stdout.println();
          stdout.println("After Virtual Register Replacement:");
          compileUnit.printIt(stdout);
        }

        compileUnit.apply(new JumpOpt(stdout));
        if (Debug.dumpModule) {
          stdout.println();
          stdout.println("After Jump Optimization:");
          compileUnit.printIt(stdout,
               new LocalAnalyzer[]{Dominators.analyzer,
                                   DominanceFrontiers.analyzer,
                                   LoopAnalysis.analyzer});
        }
      }
    } catch (SyntaxError e) {
      System.err.println("Syntax error: " + e.msg());
    }
  }
}
