package coins.backend.lir;

import coins.backend.*;
import coins.backend.sym.*;
import coins.backend.cfg.*;

/**
 * Generate LIR nodes.
 */
public class LirFactory {
  /** Next LirNode's identifier */
  int idCounter = 1;


  /** Return upper bound of LirNode id numbers. */
  public int idBound() { return idCounter; }

  /** Create FLOATCONST node */
  public LirNode fconst(int type, double value) {
    return new LirFconst(idCounter++, type, value);
  }

  /** Create INTCONST node */
  public LirNode iconst(int type, int value) {
    return new LirIconst(idCounter++, type, value);
  }

  /** Create STATIC/FRAME/REG node */
  public LirNode symRef(int opCode, int type, Symbol symbol) {
    return new LirSymRef(idCounter++, opCode, type, symbol);
  }

  /** Create LABEL/DEFLABEL node */
  public LirNode labelRef(int opCode, int type, Label label) {
    return new LirLabelRef(idCounter++, opCode, type, label);
  }

  /** Create unary operator node */
  public LirNode operator(int opCode, int type, LirNode operand) {
    return new LirUnaOp(idCounter++, opCode, type, operand);
  }

  /** Create binary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1) {
    return new LirBinOp(idCounter++, opCode, type, operand0, operand1);
  }

  /** Create ternary operator node */
  public LirNode operator(int opCode, int type, LirNode operand0,
                          LirNode operand1, LirNode operand2) {
    LirNode [] src = new LirNode[3];
    src[0] = operand0;
    src[1] = operand1;
    src[2] = operand2;
    return new LirNaryOp(idCounter++, opCode, type, src);
  }

  /** Create n-ary operator node */
  public LirNode operator(int opCode, int type, LirNode operands[]) {
    return new LirNaryOp(idCounter++, opCode, type, operands);
  }
}
