package coins.backend.lir;

import coins.backend.*;

/** Represent FLOATCONST node. */
public class LirFconst extends LirNode {
  public final double value;

  LirFconst(int id, int t, double v) {
    super(id, Op.FLOATCONST, t);
    value = v;
  }

  public String toString() {
    return "(" + Op.toName(opCode) + Debug.TypePrefix + Type.toString(type)
      + " " + value + ")";
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}

