package coins.backend.tmd;

import java.io.*;
import coins.backend.tmd.cs.*;

class Main {
  public static void main(String[] argv) throws IOException {

    InitFun.init();

    if (argv.length == 0) {
      // $B0z?t$J$7$J$i%H%C%W%l%Y%k%k!<%W$KF~$k!#(B
      InitFun.load("main.cs", true);
      Eval.readEvalPrintLoop();
    }
    else if (argv.length == 2) {
      // $B$=$&$G$J$1$l$P(B TMD $B%/%i%97PM3$N%F%9%H$r9T$J$&!#(B
      // % java Main tmdfile foo.lir
      // foo.lir $B$N:G=i$N(B L $B4X?t$K$D$$$F(B instsel $B$r<B9T!#(B

      String tmdfile = argv[0];
      String lirfile = argv[1];

      // LibLisp.evals("(set! *debug* ())");
      
      TMD tmd = new TMD(argv[0]);



      String lfunc =
	LibFun.toString(List.assq(Symbol.intern("FUNCTION"),
				  (List)
				  List.cddr((List)LibLisp.readf(lirfile))));

      lfunc = tmd.instsel(lfunc);

      System.out.println(lfunc);
    }
  }
}
