/* KandR/8-3  File copy.
   Give such command as
     a.out KnadR/8-345.in tmp
*/
#include <stdio.h>
#include <fcntl.h>
#include "syscalls.h"
#include <stdarg.h> /* ##17 */
#define PERMS 0666

void error(char *, ...);

main(int argc, char *argv[])
{
	int f1, f2, n;
	char buf[BUFSIZ];

	if (argc != 3)
		error("Usage: op from to");
	if ((f1 = open(argv[1], O_RDONLY, 0)) == -1)
		error("op: can't open %s", argv[1]);
	if ((f2 = creat(argv[2],PERMS)) == -1)
		error("cp: can't create %s, mode %03o", argv[2], PERMS);
	while ((n = read(f1, buf, BUFSIZ)) > 0)
		if (write(f2, buf, n) != n)
			error("cp: write error on file %s", argv[2]);
	return 0;
}

#include <stdio.h>
#include <stdarg.h>

void error(char *fmt, ...)
{
	va_list args;

	va_start(args, fmt);
	fprintf(stderr, "error: ");
	vfprintf(stderr, fmt, args);
	fprintf(stderr, "\n");
	va_end(args);
	exit(1);
}
