package coins.backend.lir;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.sym.*;

/** STATIC/FRAME/REG LirNode */
public class LirSymRef extends LirNode {
  public final Symbol symbol;

  LirSymRef(int id, int op, int t, Symbol sym) {
    super(id, op, t);
    symbol = sym;
  }

  public LirNode makeCopy(LirFactory fac) {
    return fac.symRef(opCode, type, symbol);
  }

  public String toString() {
    return "(" + Op.toName(opCode)
      + Debug.TypePrefix + Type.toString(type)
      + " \"" + symbol.name + "\")";
  }

  public boolean equals(LirNode x) {
    return (x instanceof LirSymRef && super.equals(x)
            && symbol == ((LirSymRef)x).symbol);
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
