package coins.backend;

import java.lang.*;
import java.io.*;
import coins.backend.*;
import coins.backend.lir.*;

/**
 * Storage class encoder/decoder.
 * Storage class is represented by int, not an instance of the class.
 */
public class LStorage implements Keywords, LirDef {
  public static String toString(int pStorage) {
    switch (pStorage){
    case ST_STATIC: return KW_STATIC;
    case ST_FRAME: return KW_FRAME;
    case ST_REG: return KW_REG;
    default: return "?";
    }
  }

  public static int decode(String pWord) throws SyntaxError {
    if (pWord == KW_STATIC)
      return ST_STATIC;
    else if (pWord == KW_FRAME)
      return ST_FRAME;
    else if (pWord == KW_REG)
      return ST_REG;
    else
      throw new SyntaxError("Expected STATIC/FRAME/REG but " + pWord);
  }
}

