package coins.backend.lir;

import coins.backend.*;

/**
 * Represent integer constant
 */
public class LirIconst extends LirNode implements LirDef {
  protected int value;

  LirIconst(int id, int t, int v) {
    super(id, OP_INTCONST, t);
    value = v;
  }

  public String toString() {
    return "(" + OpTable.toName(opCode) + TypePrefix + LType.toString(type)
      + " " + value + ")";
  }

  public void accept(LirVisitor v) {
    v.visit(this);
  }
}
