package coins.backend.sym;

import java.io.*;
import coins.backend.*;

/** Symbol table entry */
public abstract class Symbol {
  public final String name;
  public final int storage;
  public final int type;
  public final int boundary;

  /** Miscellaneous flags */
  int flags;

  /** Register objects' original variable */
  Symbol shadow;

  /** This variable was taken its address. */
  public static final int F_ADDRESSED = 1;

  Symbol(String n, int s, int t, int b) {
    name = n;
    storage = s;
    type = t;
    boundary = b;
  }

  /** Test if the given flag is up.
   *  (true returned when the flag is up) */
  public boolean testFlag(int flag) {
    return ((flags & flag) != 0);
  }

  /** Set flag 0 or 1 */
  public void setFlag(int flag, boolean yes) {
    if (yes)
      flags |= flag;
    else
      flags &= ~flag;
  }

  /** Return the shadow variable (original/register variable) */
  public Symbol shadow() { return shadow; }

  /** Set original/shadow variable */
  public void setShadow(Symbol another) {
    shadow = another;
  }

  public abstract String toString();
}
